package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.block.TileEntityGeneExtractor;

import java.util.Iterator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;

public class ContainerGeneExtractor extends Container {
	
	InventoryPlayer playerInven;
	TileEntityGeneExtractor te;
	
	SlotContaminatedItem slot0;
	SlotDNANeedle slot1;
	SlotType slot2;
	
	ResourceLocation needleOrTube = new ResourceLocation("CloneCraft:textures/items/needleOrTubeUnderlay.png");
	ResourceLocation needleDna = new ResourceLocation("CloneCraft:textures/items/needleDnaUnderlay.png");
	ResourceLocation sequencePaper = new ResourceLocation("CloneCraft:textures/items/sequencePaperUnderlay.png");
	ResourceLocation fuel = new ResourceLocation("CloneCraft:textures/items/fuelUnderlay.png");
	ResourceLocation testTube = new ResourceLocation("CloneCraft:textures/items/testTubeUnderlay.png");

	public ContainerGeneExtractor(InventoryPlayer playerInven,  TileEntityGeneExtractor te) {
		this.playerInven = playerInven;
		this.te = te;
		
		this.addSlotToContainer(new SlotContaminatedItem(te, 0, 20, 9));
		this.getSlot(0).setBackgroundIconTexture(needleOrTube);
		this.addSlotToContainer(new SlotDNANeedle(te, 1, 86, 9));
		this.getSlot(1).setBackgroundIconTexture(needleDna);
		this.addSlotToContainer(new SlotType(te, 2, 113, 9, CloneCraft.dnaData.itemID, -1, 1));
		this.getSlot(2).setBackgroundIconTexture(sequencePaper);
		this.addSlotToContainer(new SlotFuel(te, 3, 148, 51));
		this.getSlot(3).setBackgroundIconTexture(fuel);
		this.addSlotToContainer(new SlotCleanTestTube(te, 4, 80, 56));
		this.addSlotToContainer(new SlotCleanTestTube(te, 5, 7, 86));
		this.getSlot(4).setBackgroundIconTexture(testTube);
		this.getSlot(5).setBackgroundIconTexture(testTube);
		for(int a = 0; a < 8; a++){
			this.addSlotToContainer(new SlotTakeOnly(te, 13-a, 27 + (18 * a), 86));
		}
		
		this.addSlotToContainer(new SlotTakeOnly(te, 14, 178, 32));
		this.addSlotToContainer(new SlotTakeOnly(te, 15, 178, 50));
		this.addSlotToContainer(new SlotTakeOnly(te, 16, 178, 68));
		this.addSlotToContainer(new SlotTakeOnly(te, 17, 178, 86));
		
		
		
		for (int i = 0; i < 3; i++)
		{
			for (int k = 0; k < 9; k++)
			{
				addSlotToContainer(new Slot(playerInven, k + i * 9 + 9, 8 + k * 18, 116 + i * 18));
			}
		}
		for (int j = 0; j < 9; j++)
		{
			addSlotToContainer(new Slot(playerInven, j, 8 + j * 18, 174));
		}
		
		
	}

	
	
	@Override
	public boolean canInteractWith(EntityPlayer entityplayer) {
		return true;
	}

	public boolean canSlotTakeItem(Slot slot, ItemStack stack){
		return slot.isItemValid(stack) && (slot.getHasStack()?slot.getStack().stackSize < slot.getSlotStackLimit():true);
	}
	
	//>= & < 
	@Override
	public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
		Slot slotClicked = getSlot(slotClickedIndex);
		if(slotClicked != null && slotClicked.getHasStack()){
			ItemStack clickedOn = slotClicked.getStack();
			if(slotClickedIndex > 17){
				//user inven
				if(canSlotTakeItem(getSlot(0), clickedOn)){
					if (!this.mergeItemStack(clickedOn, 0, 1, false)){
						return null;
					}
				}else if(canSlotTakeItem(getSlot(1), clickedOn)){
					if (!this.mergeItemStack(clickedOn, 1, 2, false)){
						return null;
					}
				}else if(canSlotTakeItem(getSlot(2), clickedOn)){
					if (!this.mergeItemStack(clickedOn, 2, 3, false)){
						return null;
					}
				}else if(canSlotTakeItem(getSlot(5), clickedOn)){
					if (!this.mergeItemStack(clickedOn, 5, 6, false)){
						return null;
					}
				}else if(TileEntityFurnace.isItemFuel(clickedOn) && (!getSlot(3).getHasStack() || getSlot(3).getStack().stackSize < 64)){
					if (!this.mergeItemStack(clickedOn, 3, 4, false)){
						return null;
					}
				}else if(slotClickedIndex >= 18 && slotClickedIndex < 45){
					if (!this.mergeItemStack(clickedOn, 45, 54, false)){
						return null;
					}
				}else if(slotClickedIndex >= 45 && slotClickedIndex < 54){
					if (!this.mergeItemStack(clickedOn, 18, 45, false)){
						return null;
					}
				}else{
					return null;
				}
			}else{
				//te inven
				if (!this.mergeItemStack(clickedOn, 18, 54, false)){
					return null;
				}
			}
			if (clickedOn.stackSize == 0)
            {
				slotClicked.putStack((ItemStack)null);
            }
            else
            {
            	slotClicked.onSlotChanged();
            }
			return clickedOn;
		}
		return null;
	}
	
	
	
	/*else if(clickedOn.itemID == CloneCraft.testTube.itemID && clickedOn.getItemDamage() == 0 && !new ItemData(clickedOn).isContaminated()){
		for(int a = 0; a < 9; a++){
			Slot slot = this.getSlot(5+a);
			if(!slot.getHasStack()){
				clickedOn.stackSize--;
				ItemStack copy = clickedOn.copy();
				copy.stackSize = 1;
				slot.putStack(copy);
			}
		}
	}*/
	
	
	@Override
	protected void retrySlotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
		//Stuff You!
	}

	@Override
	public void addCraftingToCrafters(ICrafting par1iCrafting) {
		super.addCraftingToCrafters(par1iCrafting);
		par1iCrafting.sendProgressBarUpdate(this, 0, te.currentItemBurnTime);
		par1iCrafting.sendProgressBarUpdate(this, 1, te.burnTime);
		par1iCrafting.sendProgressBarUpdate(this, 2, te.extractTime);
	}

	private int lastCurrentItemBurnTime;
	private int lastBurnTime;
	private int lastExtractTime;

	@Override
	public void detectAndSendChanges() {
		super.detectAndSendChanges();
		Iterator var1 = crafters.iterator();
		while(var1.hasNext()){
			ICrafting crafting = (ICrafting)var1.next();
			if(te.currentItemBurnTime != lastCurrentItemBurnTime){
				crafting.sendProgressBarUpdate(this, 0, te.currentItemBurnTime);
			}
			if(te.burnTime != lastBurnTime){
				crafting.sendProgressBarUpdate(this, 1, te.burnTime);
			}
			if(te.extractTime != lastExtractTime){
				crafting.sendProgressBarUpdate(this, 2, te.extractTime);
			}
		}

		lastCurrentItemBurnTime = te.currentItemBurnTime;
		lastBurnTime = te.burnTime;
		lastExtractTime = te.extractTime;
	}

	@Override
	public void updateProgressBar(int par1, int par2) {
		if(par1 == 0){
			te.currentItemBurnTime = par2;
		}
		if(par1 == 1){
			te.burnTime = par2;
		}
		if(par1 == 2){
			te.extractTime = par2;
		}
	}

}
